// proxy pattern
define([ 'jquery' ],
    function ($) {
        var focus = $.fn.focus;

        // using timeout to get past shadow click in iOS (Safari)
        var focusRace;
        var requireDelay = /iPhone|iPad|iPod/.test(navigator.platform) && navigator.userAgent.indexOf('AppleWebKit') > -1;

        // to set focus in Android (Chrome) and iOS (Safari), need to blur first
        $.fn.focus = function() {
            clearTimeout(focusRace);
            focusRace = setTimeout(function() {
                this.blur();
                focus.apply(this, arguments);
            }.bind(this), requireDelay ? 0 : 600);
        };
    });
